/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	PIGetPathSuite.h
 *
 * Copyright 1986-2000 Adobe Systems Incorporated.
 * All Rights Reserved.
 *
 * Purpose:
 *	This file contains all the public definitions and
 *	structures related to user interface elements.
 *
 *	Use the GetPath suite to get the path from FSSpec
 *	
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *		Version 1.0.0	2/9/1999	SAK		Created for Photoshop 5.5.
 *			Created by Sarah Kong.
 */

#ifndef __PIGetPathSuite__
#define __PIGetPathSuite__

//-------------------------------------------------------------------------------
//	Includes.
//-------------------------------------------------------------------------------
#include "PIGeneral.h"

//-------------------------------------------------------------------------------
//	C++ wrapper.
//-------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif

//-------------------------------------------------------------------------------
//	UI GetPath suite.
//-------------------------------------------------------------------------------
#define kPSGetPathSuite 			"Photoshop GetPath Suite for Plug-ins"

//-------------------------------------------------------------------------------
//	
//-------------------------------------------------------------------------------
typedef SPAPI void (*GetPathNameProc) (SPPlatformFileSpecification* fileSpec, char* path, int16 maxLength );

//-------------------------------------------------------------------------------
//	 GetPath suite version 1.
//-------------------------------------------------------------------------------

#define kPSGetPathSuiteVersion1		1

typedef struct 
	{
	GetPathNameProc 		GetPathName;
	} PSGetPathSuite1;


//-------------------------------------------------------------------------------
//	C++ wrapper.
//-------------------------------------------------------------------------------
#ifdef __cplusplus
}
#endif

//-------------------------------------------------------------------------------
#endif	// PIGetPathSuite
